from typing import List


class CraftAlphabet:

    def __init__(
            self,
            craft_item_list: List[str],
            operations: List[str],
            prefix: str='craft',
            suffix: str=''
            ) -> None:
        self.craft_items = craft_item_list
        self.ops = operations
        self.prefix = prefix
        self.suffix = suffix
        self._build_alphabet()

    def _build_alphabet(self):
        self._alphabet = []
        for item_name in self.craft_items:
            for op in self.ops:
                self._alphabet.append('.'.join([self.prefix, item_name]) + op + self.suffix)
    
    @property
    def alphabet(self):
        return self._alphabet

    def __getitem__(self, index: int):
        return self._alphabet[index]
    
    def __str__(self) -> str:
        return str(self._alphabet)
    

class MineAlphabet:

    def __init__(
            self, 
            mine_item_list: List[str],
            operations: List[str],
            prefix: str='mine',
            suffix: str=''
            ) -> None:
        self.mine_items = mine_item_list
        self.ops = operations
        self.prefix = prefix
        self.suffix = suffix
        self._build_alphabet()

    def _build_alphabet(self):
        self._alphabet = []
        for item_name in self.mine_items:
            for op in self.ops:
                self._alphabet.append('.'.join([self.prefix, item_name]) + op + self.suffix)
    
    @property
    def alphabet(self):
        return self._alphabet

    def __getitem__(self, index: int):
        return self._alphabet[index]
    
    def __str__(self) -> str:
        return str(self._alphabet)


if __name__ == '__main__':
    ca = CraftAlphabet(craft_item_list=['oak_planks', 'crafting_table'], operations=['>='], suffix='[integer]')
    ma = MineAlphabet(mine_item_list=['oak_log'], operations=['>='], suffix='[integer]')
    print(ca)
    print(ma)
